/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nic;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.nic.eui.ConfigurationFolderGroup;
import ibm.nways.nic.eui.NicInfoGroup;
import ibm.nways.nic.eui.SystemFolderGroup;
import ibm.nways.nic.eui.SystemGeneralFolderGroup;
import java.util.ResourceBundle;

public class AdapterJdm
extends JdmBrowser {
    NavigationFolder root;
    NavigationFolder configurationFolder;
    NavigationFolder nicSystemFolder;
    GenModel model;
    GenModel configurationFolderModel;
    GenModel systemFolderModel;
    private ResourceBundle NicBundle;
    private NavigationBrowser tree;

    public String getModelTypeName() {
        return "ibm.nways.nic.model.Adapter";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        return null;
    }

    protected NavigationPoint getNavTreeRoot() {
        this.NicBundle = ResourceBundle.getBundle("ibm.nways.nic.NicResources");
        this.displayMsg(this.NicBundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(this.NicBundle.getString("serverDone"));
        this.root = new NavigationFolder(this.NicBundle.getString("generic"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put("TREE", this.tree);
        NavigationFolder navigationFolder = (NavigationFolder)this.getNavigationTree();
        this.buildConfigurationFolder();
        this.buildSystemFolder();
        this.buildSystem();
        this.buildDmi();
        this.buildOtherApps();
        this.displayMsg(this.NicBundle.getString("initDone"));
    }

    private void buildConfigurationFolder() {
        if (this.configurationFolderModel == null) {
            try {
                this.configurationFolderModel = (GenModel)this.model.getComponent("ConfigurationFolder");
            }
            catch (Exception exception) {
                System.out.println("Exception getting ConfigurationFolder Model");
            }
        }
        this.configurationFolder = new ConfigurationFolderGroup(this, this.configurationFolderModel);
        this.configurationFolder.setIsInitiallyExpanded(true);
        this.tree.addEventListener((ConfigurationFolderGroup)this.configurationFolder);
        this.root.add(this.configurationFolder);
    }

    private void buildSystemFolder() {
        if (this.systemFolderModel == null) {
            try {
                this.systemFolderModel = (GenModel)this.configurationFolderModel.getComponent("SystemFolder");
            }
            catch (Exception exception) {
                System.out.println("Exception getting SystemFolder Model");
            }
        }
        this.nicSystemFolder = new SystemFolderGroup(this, this.systemFolderModel);
        this.nicSystemFolder.setIsInitiallyExpanded(true);
        this.tree.addEventListener((SystemFolderGroup)this.nicSystemFolder);
        this.configurationFolder.add(this.nicSystemFolder);
    }

    private void buildSystem() {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("System");
            if (genModel != null) {
                SystemGeneralFolderGroup systemGeneralFolderGroup = new SystemGeneralFolderGroup(this, genModel);
                systemGeneralFolderGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener(systemGeneralFolderGroup);
                this.nicSystemFolder.add(systemGeneralFolderGroup);
                systemGeneralFolderGroup.add(new NavigationItem(this.NicBundle.getString("Identification"), new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", genModel), "SystemFolder"));
                SnmpContextModel snmpContextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
                systemGeneralFolderGroup.add(new NavigationItem(this.NicBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", snmpContextModel), "SnmpConfig"));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildDmi() {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("Nic");
            if (genModel != null) {
                NicInfoGroup nicInfoGroup = new NicInfoGroup(this, genModel);
                nicInfoGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener(nicInfoGroup);
                this.nicSystemFolder.add(nicInfoGroup);
                return;
            }
            System.out.println("Nic null");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void buildOtherApps() {
        NavigationFolder navigationFolder = new NavigationFolder(this.NicBundle.getString("otherApps"));
        this.root.add(navigationFolder);
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
            Browser browser = new Browser("MIB Browser", this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener(browser);
            navigationFolder.add(browser.getRootFolder());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

